﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/ipc/bcat_IDeliveryCacheStorageService.sfdl.h>
#include <nn/bcat/detail/service/bcat_Capability.h>
#include <nn/bcat/detail/service/bcat_ServiceMemoryManager.h>

namespace nn { namespace bcat { namespace detail { namespace service {

/*!
    @brief      データ配信キャッシュストレージのサービスです。
*/
class DeliveryCacheStorageService : public nn::sf::ISharedObject
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  appId       アプリケーション ID。
        @param[in]  capability  ケイパビリティ。
    */
    DeliveryCacheStorageService(nn::ApplicationId appId, const Capability& capability) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~DeliveryCacheStorageService() NN_NOEXCEPT;

    /*!
        @brief      データ配信キャッシュファイルサービスの削除を通知します。
    */
    void NotifyFileServiceDeleted() NN_NOEXCEPT;

    /*!
        @brief      データ配信キャッシュディレクトリサービスの削除を通知します。
    */
    void NotifyDirectoryServiceDeleted() NN_NOEXCEPT;

public:
    // IDeliveryCacheStorageService
    nn::Result CreateFileService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheFileService>> outService) NN_NOEXCEPT;
    nn::Result CreateDirectoryService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheDirectoryService>> outService) NN_NOEXCEPT;
    nn::Result EnumerateDeliveryCacheDirectory(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::DirectoryName>& outDirectoryNames) NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    Capability m_Capability;
    //
    nn::ApplicationId m_AppId;
    //
    int m_FileCount;
    int m_DirCount;
};

NN_STATIC_ASSERT(sizeof (DeliveryCacheStorageService) <= detail::service::ServiceMemoryManager::DeliveryCacheStorageServiceSize);

}}}}
