﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/ipc/bcat_IDeliveryCacheStorageService.sfdl.h>
#include <nn/bcat/detail/service/bcat_ServiceMemoryManager.h>

namespace nn { namespace bcat { namespace detail { namespace service {

/*!
    @brief      データ配信キャッシュストレージのサービスです。
*/
class DeliveryCacheStorageServiceForGeneric : public nn::sf::ISharedObject
{
public:
    /*!
        @brief      コンストラクタです。
    */
    DeliveryCacheStorageServiceForGeneric() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~DeliveryCacheStorageServiceForGeneric() NN_NOEXCEPT;

public:
    // IDeliveryCacheStorageService
    nn::Result CreateFileService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheFileService>> outService) NN_NOEXCEPT;
    nn::Result CreateDirectoryService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheDirectoryService>> outService) NN_NOEXCEPT;
    nn::Result EnumerateDeliveryCacheDirectory(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::DirectoryName>& outDirectoryNames) NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
};

NN_STATIC_ASSERT(sizeof (DeliveryCacheStorageServiceForGeneric) <= detail::service::ServiceMemoryManager::DeliveryCacheStorageServiceSize);

}}}}
