﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/ipc/bcat_IDeliveryCacheProgressService.sfdl.h>
#include <nn/bcat/detail/service/bcat_Capability.h>
#include <nn/bcat/detail/service/bcat_ServiceMemoryManager.h>

namespace nn { namespace bcat { namespace detail { namespace service {

/*!
    @brief      データ配信の進捗のサービスです。
*/
class DeliveryCacheProgressService
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  sessionId   セッション ID。
        @param[in]  taskId      タスク ID。
        @param[in]  capability  ケイパビリティ。
    */
    DeliveryCacheProgressService(SessionId sessionId, TaskId taskId, const Capability& capability) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~DeliveryCacheProgressService() NN_NOEXCEPT;

public:
    // IDeliveryCacheProgressService
    nn::Result GetEvent(nn::sf::Out<nn::sf::NativeHandle> outEvent) NN_NOEXCEPT;
    nn::Result GetImpl(nn::sf::Out<nn::bcat::detail::DeliveryCacheProgressImpl> outImpl) NN_NOEXCEPT;

private:
    //
    Capability m_Capability;
    //
    SessionId m_SessionId;
    TaskId m_TaskId;
    //
    nn::os::SystemEvent m_Event;
};

NN_STATIC_ASSERT(sizeof (DeliveryCacheProgressService) <= detail::service::ServiceMemoryManager::DeliveryCacheProgressServiceSize);

}}}}
