﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/bcat/bcat_Types.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace bcat { namespace detail { namespace ipc { // NOLINT(whitespace/braces)

class IDeliveryCacheFileService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDeliveryCacheFileService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDeliveryCacheFileService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Open, (const ::nn::bcat::DirectoryName& dirName, const ::nn::bcat::FileName& fileName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<::std::uint64_t> outSize, ::std::int64_t offset, const ::nn::sf::OutBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::int64_t> outSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDigest, (::nn::sf::Out<::nn::bcat::Digest> outDigest))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDeliveryCacheFileService)

        ::nn::Result Open(const ::nn::bcat::DirectoryName& dirName, const ::nn::bcat::FileName& fileName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Open, (dirName, fileName));
        }

        ::nn::Result Read(::nn::sf::Out<::std::uint64_t> outSize, ::std::int64_t offset, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Read, (outSize, offset, buffer));
        }

        ::nn::Result GetSize(::nn::sf::Out<::std::int64_t> outSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSize, (outSize));
        }

        ::nn::Result GetDigest(::nn::sf::Out<::nn::bcat::Digest> outDigest) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDigest, (outDigest));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDeliveryCacheFileService
    {
    public:
        nn::Result Open(const nn::bcat::DirectoryName& dirName, const nn::bcat::FileName& fileName) NN_NOEXCEPT;
        nn::Result Read(nn::sf::Out<std::uint64_t> outSize, std::int64_t offset, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result GetSize(nn::sf::Out<std::int64_t> outSize) NN_NOEXCEPT;
        nn::Result GetDigest(nn::sf::Out<nn::bcat::Digest> outDigest) NN_NOEXCEPT;
    };
#endif

}}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Open(const nn::bcat::DirectoryName& dirName, const nn::bcat::FileName& fileName) NN_NOEXCEPT;
    nn::Result Read(nn::sf::Out<std::uint64_t> outSize, std::int64_t offset, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result GetSize(nn::sf::Out<std::int64_t> outSize) NN_NOEXCEPT;
    nn::Result GetDigest(nn::sf::Out<nn::bcat::Digest> outDigest) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::bcat::detail::ipc::IDeliveryCacheFileService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Open, (const ::nn::bcat::DirectoryName& dirName, const ::nn::bcat::FileName& fileName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Open, (dirName, fileName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<::std::uint64_t> outSize, ::std::int64_t offset, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Read, (outSize, offset, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::int64_t> outSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSize, (outSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDigest, (::nn::sf::Out<::nn::bcat::Digest> outDigest))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDigest, (outDigest));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::bcat::detail::ipc::IDeliveryCacheFileService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::bcat::detail::ipc::IDeliveryCacheFileService))

    // nn::Result Open(const nn::bcat::DirectoryName& dirName, const nn::bcat::FileName& fileName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Open)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dirName, (::nn::bcat::DirectoryName), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileName, (::nn::bcat::FileName), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (dirName, fileName))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dirName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Open)

    // nn::Result Read(nn::sf::Out<std::uint64_t> outSize, std::int64_t offset, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Read)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Read)

    // nn::Result GetSize(nn::sf::Out<std::int64_t> outSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSize)

    // nn::Result GetDigest(nn::sf::Out<nn::bcat::Digest> outDigest) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDigest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outDigest, (::nn::bcat::Digest), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outDigest))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDigest)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDigest)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bcat::DirectoryName), 32, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bcat::FileName), 32, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bcat::Digest), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::bcat::detail::ipc::IDeliveryCacheFileService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::bcat::detail::ipc::IDeliveryCacheFileService))

    // nn::Result Open(const nn::bcat::DirectoryName& dirName, const nn::bcat::FileName& fileName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Open, (const ::nn::bcat::DirectoryName& dirName, const ::nn::bcat::FileName& fileName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Open)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dirName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Open)
    }

    // nn::Result Read(nn::sf::Out<std::uint64_t> outSize, std::int64_t offset, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<::std::uint64_t> outSize, ::std::int64_t offset, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Read)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Read)
    }

    // nn::Result GetSize(nn::sf::Out<std::int64_t> outSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::int64_t> outSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSize)
    }

    // nn::Result GetDigest(nn::sf::Out<nn::bcat::Digest> outDigest) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDigest, (::nn::sf::Out<::nn::bcat::Digest> outDigest))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDigest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDigest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDigest)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::bcat::detail::ipc::IDeliveryCacheFileService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::bcat::detail::ipc::IDeliveryCacheFileService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Open)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Open)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dirName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Read)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Read)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDigest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDigest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outDigest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Open)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Read)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDigest)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::bcat::detail::ipc::IDeliveryCacheFileService))
