﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/applet/applet_Types.h>
#include <nn/applet/applet_Storage.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace applet {

//! @name   試遊台向けのアプリケーション制御機能
//! @{

/**
 * @brief アプリケーションに付加する拡張属性を保持する構造体です。
 *
 */
struct ApplicationAttributeForQuest
{
    uint32_t playableTime;          //!< アプリのプレイ可能時間（秒）
    uint32_t idleDetectionTime;     //!< アプリの無操作時間検知時間（秒）
};


/**
    @brief  拡張属性を付加してアプリケーションの起動要求を出します。

    @param[in] applicationId  起動要求を出すアプリケーションの applicationId
    @param[in] storageHandle  再起動したアプリが取得できるストレージのハンドル
    @param[in] pAttribute     再起動するアプリに付加する拡張属性

    @pre
     - pAttribute->playableTime >= 0
     - pAttribute->idleDetectionTime >= 0

    @details
     本 API は試遊台環境向けの機能です。

     試遊台環境において applicationId で指定されたアプリの起動要求を出します。
     基本的な機能は nn::applet::RequestToLaunchApplication() と等価ですが、
     アプリケーション拡張属性 pAttribute を指定できる点が異なります。

     詳細は nn::applet::RequestToLaunchApplication() も参照して下さい。

*/
void RequestToLaunchApplicationForQuest(ncm::ApplicationId applicationId, StorageHandle storageHandle, const ApplicationAttributeForQuest* pAttribute) NN_NOEXCEPT;

//! @}

}} // namespace nn::applet

