﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief 性能に関係するイベントの識別子の定義。
 */

#pragma once

namespace nn { namespace apm {

/**
 * @brief   性能に関係するイベントを表す列挙型です。
 */
enum EventTarget
{
    EventTarget_PerformanceModeChanged, //!< 性能モードが切り替わったことを示すイベントです。
    EventTarget_SleepRequiredByLowVoltage, //!< 電圧が低下していることを示すイベントです。
};

/**
 * @brief   スロットリング状態を表す構造体です。
 */
struct ThrottlingState
{
    int64_t durationNanoSeconds;    //!< スロットリングの発動時間です。ナノ秒単位です。スロットリングが発動していない場合は 0 が格納されます。
    int  throttlingRateCpuDividend; //!< スロットリング発動中に CPU のクロックに積算される数です。
    int  throttlingRateCpuDivisor;  //!< スロットリング発動中の CPU クロックの除数です。
    int  throttlingRateGpuDividend; //!< スロットリング発動中に GPU のクロックに積算される数です。
    int  throttlingRateGpuDivisor;  //!< スロットリング発動中の GPU クロックの除数です。

    uint32_t throttleStatus;        //!< スロットリング全体の詳細な状態を表すフィールドです。
    uint32_t cpuPSkipStatus;        //!< CPU のスロットリングの状態を表すフィールドです。
    uint32_t gpuPSkipStatus;        //!< GPU のスロットリングの状態を表すフィールドです。

    bool enabled;                   //!< スロットリングの有効・無効を表すフラグです。
    bool invoked;                   //!< スロットリングの発動・非発動を表すフラグです。

    void Clear() NN_NOEXCEPT
    {
        durationNanoSeconds = 0;
        throttlingRateCpuDividend = 0;
        throttlingRateCpuDivisor = 0;
        throttlingRateGpuDividend = 0;
        throttlingRateGpuDivisor = 0;

        throttleStatus = 0x00000000;
        cpuPSkipStatus = 0x00000000;
        gpuPSkipStatus = 0x00000000;

        enabled = false;
        invoked = false;
    }
};

}} // namespace nn::apm
