﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/aocsrv/detail/aocsrv_IAddOnContentManager.sfdl.h>
#include <nn/os/os_Mutex.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ns/ns_ApplicationContentMetaApi.h>

namespace nn { namespace aocsrv { namespace detail { // NOLINT(whitespace/braces)
    class AddOnContentManagerImpl
    {
    public:

        AddOnContentManagerImpl() NN_NOEXCEPT;
        AddOnContentManagerImpl(nn::ns::ApplicationContentMetaStatus* listBuffer, int maxListupCount) NN_NOEXCEPT;
        nn::Result CountAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
        nn::Result ListAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, std::int32_t offset, std::int32_t count, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
        nn::Result CountAddOnContent(nn::sf::Out<std::int32_t> outCount, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result ListAddOnContent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, nn::Bit64 processId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT;
        nn::Result GetAddOnContentBaseIdByApplicationId(nn::sf::Out<nn::Bit64> outValue, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
        nn::Result GetAddOnContentBaseId(nn::sf::Out<nn::Bit64> outValue, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result PrepareAddOnContentByApplicationId(nn::aoc::AddOnContentIndex targetIndex, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
        nn::Result PrepareAddOnContent(nn::aoc::AddOnContentIndex targetIndex, nn::Bit64 processId) NN_NOEXCEPT;

        nn::Result GetAddOnContentListChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;

    private:
        int m_MaxListupCount;
        nn::ns::ApplicationContentMetaStatus* m_pListBuffer;
        nn::os::Mutex m_ListLockMutex;
    };
}}}
