﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/capsrv/capsrv_ScreenShotControl.h>
#include <nn/capsrv/capsrv_SystemReservedInfo.h>

namespace nn{ namespace am{ namespace service{ namespace display{

    class ScreenShotOperation
    {
    public:

        // 画面写真の撮影を要求する。
        static nn::Result RequestTakingScreenShot(
            nn::os::Tick tick,
            nn::ncm::ApplicationId applicationId,
            nn::applet::AppletResourceUserId aruid,
            const nn::capsrv::ScreenShotAttribute& attribute,
            const nn::capsrv::UserIdList& userIdList,
            nn::TimeSpan timeout
            ) NN_NOEXCEPT;

        // 画面写真撮影をキャンセルする。
        // この関数から返って以降のディスプレイの操作結果が tick 以前の撮影要求によって画面写真として保存されないことが保証される。
        static nn::Result CancelTakingScreenShotAsNoTarget(nn::os::Tick tick) NN_NOEXCEPT;
        static nn::Result CancelTakingScreenShotAsProhibited(nn::os::Tick tick) NN_NOEXCEPT;

        static nn::Result NotifyScreenShotRefused(nn::os::Tick tick, nn::ncm::ApplicationId applicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        static nn::Result NotifyScreenShotFailed(nn::os::Tick tick, nn::ncm::ApplicationId applicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;

    };

}}}}
