﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace am{ namespace service{ namespace display{

    // システム共有バッファを作成するために vi 側に確保するメモリの大きさ。
    // IntegratedDisplayParameter で指定するレイアウトはこのサイズに収まるようにすること。
    //
    // 拡大した場合は必ず vi のリビルドも必要。
    static const size_t RequiredSystemSharedBufferStaticStorageSize = 7 * 3932160;

    // 起動ロゴのパラメータ
    // 変更した場合は vi のリビルドが必要
    static const int StartupLogoWidth  = 308;
    static const int StartupLogoHeight = 350;
    static const int StartupLogoPositionX = 1280 / 2 - StartupLogoWidth / 2;
    static const int StartupLogoPositionY = 720 / 2 - StartupLogoHeight / 2;
    static const size_t StartupLogoSize  = StartupLogoWidth * StartupLogoHeight * 4;
    static const uint32_t StartupLogoBgColor = 0xFF000000;


}}}}
