﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/os/os_Mutex.h>
#include <nn/os/os_ConditionVariable.h>
#include <nn/ae/ae_Types.h>
#include <nn/util/util_Optional.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/vi/vi_LayerStack.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/vi/fbshare/vi_SharedBufferHandle.h>
#include <nn/am/service/am_CaptureBufferIndex.h>

#include <cstring>

namespace nn { namespace am { namespace service { namespace display {

    static const uint32_t ColorOpaqueBlackRgba32 = 0xFF000000;

class CaptureBufferManager
{
private:
    class CaptureBuffer
    {
    private:
        bool            m_IsCaptureImageValid{false};
        bool            m_IsCaptureImageCopyrighted{false};

    public:
        void Initialize() NN_NOEXCEPT
        {
        }

        void SetCaptureImageValidity(bool isValid) NN_NOEXCEPT
        {
            m_IsCaptureImageValid = isValid;
        }

        bool IsCaptureImageValid() const NN_NOEXCEPT
        {
            return m_IsCaptureImageValid;
        }

        void SetCaptureImageCopyrighted(bool isCopyrighted) NN_NOEXCEPT
        {
            m_IsCaptureImageCopyrighted = isCopyrighted;
        }

        bool IsCaptureImageCopyrighted() const NN_NOEXCEPT
        {
            return m_IsCaptureImageCopyrighted;
        }
    };

private:
    CaptureBuffer m_CaptureBuffer[CaptureBufferIndex_Max];

public:
    explicit CaptureBufferManager() NN_NOEXCEPT
    {
        for (int i=0; i<CaptureBufferIndex_Max; ++i)
        {
            m_CaptureBuffer[i].Initialize();
        }
    }

    bool IsBufferScreenshotEnabled(CaptureBufferIndex index) NN_NOEXCEPT;
    bool IsBufferCopyrightRequested(CaptureBufferIndex index) NN_NOEXCEPT;
    void SetCaptureBufferState(CaptureBufferIndex index, bool isCaptureEnabled, bool isCopyrighted) NN_NOEXCEPT;

// @}
};

}}}}
