﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/am/service/am_CaptureBufferIndex.h>
#include <nn/am/service/display/am_IntegratedDisplayLayerHandle.h>
#include <nn/am/service/display/am_IntegratedDisplayLayer.h>
#include <nn/am/service/display/am_IntegratedDisplayLayerPool.h>

namespace nn{ namespace am{ namespace service{ namespace display{ namespace detail{

    class AppletPresentationResourceAccessor;

    class AppletPresentationManager
    {
    public:
        static const IntegratedDisplayLayerHandle ActiveLayerNone = -100;
        static const IntegratedDisplayLayerHandle ActiveLayerTransition = -101;

    public:
        enum State
        {
            State_Suspended,
            State_Running,
        };

    public:
        void Initialize(const AppletPresentationResourceAccessor& resAccessor) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void Suspend() NN_NOEXCEPT;
        void Resume() NN_NOEXCEPT;

        void UpdateActiveLayer() NN_NOEXCEPT;

        void NotifyConductorChanged(IntegratedDisplayLayerHandle hLayer) NN_NOEXCEPT;
        void ImmediateCaptureCurrentFullscreenLayer(CaptureBufferIndex index, bool isScreenShotPermitted) NN_NOEXCEPT;

        // Current の Fullscreen が None であれば Transition に変更する。そうでなければ何もしない。
        void ShowTransitionBuffer() NN_NOEXCEPT;
        // Current の Fullscreen が Transition であれば None に変更する。そうでなければ何もしない。
        void HideTransitionBuffer() NN_NOEXCEPT;

        IntegratedDisplayLayerHandle GetCurrentActiveFullscreenLayerHandle() const NN_NOEXCEPT { return m_CurrentActiveFullscreenLayerHandle; }
        IntegratedDisplayLayerHandle GetCurrentActivePartialLayerHandle()    const NN_NOEXCEPT { return m_CurrentActivePartialLayerHandle; }
        IntegratedDisplayLayerHandle GetCurrentActiveOverlayLayerHandle()    const NN_NOEXCEPT { return m_CurrentActiveOverlayLayerHandle; }

    private:
        void UpdateActiveLayerImpl() NN_NOEXCEPT;

        static void CalculateNewActiveLayerImpl(
            IntegratedDisplayLayerHandle* pOutNewActiveFullscreenLayerHandle,
            IntegratedDisplayLayerHandle* pOutNewActivePartialLayerHandle,
            IntegratedDisplayLayerHandle* pOutNewActiveOverlayLayerHandle,
            const IntegratedDisplayLayerPool* pLayerPool
        ) NN_NOEXCEPT;

    // @name Fullscreen
    // @{

        // @post m_CurrentActiveFullscreenLayerHandle == AvtiveLayerNone or ActiveLayerTransition
        void DeactivateCurrentActiveFullscreenLayerImpl(bool isUpdateCaptureBufferEnabled) NN_NOEXCEPT;
        // 自前レイヤの Deactivate を行う。新しい Foreground レイヤのハンドルを返す。
        IntegratedDisplayLayerHandle DeactivateCurrentActiveFullscreenDirectLayerImpl(
            IntegratedDisplayLayerHandle hOldActiveLayer,
            bool isUpdateCaptureBufferEnabled
        ) NN_NOEXCEPT;
        // 共有レイヤの Deactivate を行う。新しい Foreground レイヤのハンドルを返す。
        IntegratedDisplayLayerHandle DeactivateCurrentActiveFullscreenSharedLayerImpl(
            IntegratedDisplayLayerHandle hOldActiveLayer,
            bool isUpdateCaptureBufferEnabled
        ) NN_NOEXCEPT;

        // @post m_CurrentActiveFullscreenLayerHandle == hAvtiveLayer
        void ActivateFullscreenLayerImpl(IntegratedDisplayLayerHandle hNewActiveLayer) NN_NOEXCEPT;
        void ActivateFullscreenDirectLayerImpl(IntegratedDisplayLayerHandle hNewActiveLayer) NN_NOEXCEPT;
        void ActivateFullscreenSharedLayerImpl(IntegratedDisplayLayerHandle hNewActiveLayer) NN_NOEXCEPT;
    // @}

    // @name Partial, Overlay
    // @{
        void DeactivateCurrentPartialLayerImpl() NN_NOEXCEPT;
        void ActivatePartialLayerImpl(IntegratedDisplayLayerHandle newActiveLayer) NN_NOEXCEPT;

        void DeactivateCurrentOverlayLayerImpl() NN_NOEXCEPT;
        void ActivateOverlayLayerImpl(IntegratedDisplayLayerHandle newActiveLayer) NN_NOEXCEPT;
    // @}

    // @name 補助関数
    // @{

        // 全画面表示に使用する vi のレイヤ ID を取得する。
        // 自前バッファの場合は DirectId, 共有バッファの場合はシステム共有レイヤの ID を返す。
        // 全画面でない場合は無効値 (0) を返す。
        nn::vi::LayerId GetFullscreenLayerIdImpl(IntegratedDisplayLayerHandle handle) const NN_NOEXCEPT;

        // 遷移レイヤをシステム共有レイヤに表示する。
        void PresentTransitionBufferImpl() NN_NOEXCEPT;
        // システム共有レイヤを空にする。
        void BlankSystemSharedLayerImpl() NN_NOEXCEPT;

        // 権利表記レイヤを撮影対象に含める。既に撮影対象になっていたら何もしない。
        void ShowApplicationCopyrightLayerImpl() NN_NOEXCEPT;
        // 権利表記レイヤを撮影対象から除外する。既に撮影対象でないならば何もしない。
        void HideApplicationCopyrightLayerImpl() NN_NOEXCEPT;
    // @}

    private:
        State m_State = State_Suspended;

        AppletPresentationResourceAccessor* m_pResource = nullptr;
        NN_ALIGNAS(8) char m_ResourceAccessorStorage[8];

        IntegratedDisplayLayerHandle m_CurrentActiveFullscreenLayerHandle = ActiveLayerNone;
        IntegratedDisplayLayerHandle m_CurrentActivePartialLayerHandle    = ActiveLayerNone;
        IntegratedDisplayLayerHandle m_CurrentActiveOverlayLayerHandle    = ActiveLayerNone;

        struct
        {
            IntegratedDisplayLayerHandle m_SuspendedFullscreenLayerHandle = ActiveLayerNone;
            IntegratedDisplayLayerHandle m_SuspendedPartialLayerHandle    = ActiveLayerNone;
            IntegratedDisplayLayerHandle m_SuspendedOverlayLayerHandle    = ActiveLayerNone;
        } m_SuspendState;
    };

}}}}}
