﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace am { namespace service {

void SetConfigsByFirmwareDebugSettings();

void EnableDevelopmentFunction() NN_NOEXCEPT;
bool IsDevelopmentFunctionEnabled() NN_NOEXCEPT;

bool AbortsOnSystemAppletLost() NN_NOEXCEPT;
bool AbortsOnOverlayAppletLost() NN_NOEXCEPT;

bool KillsApplicationOnGpuError() NN_NOEXCEPT;
bool DumpsApplicationGpuCoreDumpOnGpuError() NN_NOEXCEPT;

bool NegatesTransitionLayerTexture() NN_NOEXCEPT;

bool IsQuestMode() NN_NOEXCEPT;
bool IsProdMode() NN_NOEXCEPT;

bool IsContinuousRecordingForceDisabled() NN_NOEXCEPT;

TimeSpan GetInitialDefaultHomeLongPressTime() NN_NOEXCEPT;

TimeSpan GetCaptureLongPressTime() NN_NOEXCEPT;
uint32_t GetDefaultContinuousRecordingVideoBitRate() NN_NOEXCEPT;
TimeSpan GetDefaultContinuousRecordingMaxTime() NN_NOEXCEPT;
TimeSpan GetDefaultContinuousRecordingMinTime() NN_NOEXCEPT;
uint8_t GetDefaultContinuousRecordingFps() NN_NOEXCEPT;
uint16_t GetDefaultContinuousRecordingFrameCountBetweenIdr() NN_NOEXCEPT;
TimeSpan GetDefaultContinuousRecordingAdditionalTimeOnDockInOut() NN_NOEXCEPT;
bool IsContinuousRecordingDebugMode() NN_NOEXCEPT;
TimeSpan GetContinuousRecordingMaxTimeOnDebugMode() NN_NOEXCEPT;
size_t GetContinuousRecordingExtraMemorySize(Bit64 applicationId) NN_NOEXCEPT;
bool SavesMovieAutomaticallyOnException() NN_NOEXCEPT;
util::optional<Bit64> GetApplicationIdByContentActionNameByDebugConfig(const char* name) NN_NOEXCEPT;

}}}

#define NN_AM_SERVICE_CHECK_DEVELOPMENT_FUNCTION \
    NN_RESULT_THROW_UNLESS(::nn::am::service::IsDevelopmentFunctionEnabled(), ::nn::am::ResultDevelopmentFunctionCalled())
