﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/pdm/pdm_SystemTypes.h>
#include <nn/ns/ns_ApplicationControlDataApi.h>

namespace nn { namespace am { namespace service {
    void InitializePlayDataManager() NN_NOEXCEPT;

    void NotifyAppletEvent(pdm::AppletEventType eventType, nn::ncm::ProgramId programId, uint32_t version, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT;

    void NotifyLibraryAppletEvent(pdm::AppletEventType eventType, nn::ncm::ProgramId programId, applet::LibraryAppletMode libraryAppletMode, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT;

    void NotifyOperationModeChangeEvent(oe::OperationMode operationMode) NN_NOEXCEPT;

    void NotifyPowerStateChangeEvent(pdm::PowerStateChangeEventType eventType) NN_NOEXCEPT;
}}}
