﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/sf/sf_Types.h>
#include <memory>

namespace nn { namespace am {

typedef applet::AppletResourceUserId    AppletResourceUserId;
typedef applet::AppletId                AppletId;

struct AppletMessage
{
    Bit32 message[1];
};

enum IdleTimeDetectionExtension : uint32_t
{
    IdleTimeDetectionExtension_Disabled = 0,
    IdleTimeDetectionExtension_Enabled = 1,
    IdleTimeDetectionExtension_EnabledUnsafe = 2,
};

struct AppletAttribute
{
    bool  isVrModeDualScreenSupported;
    Bit8  reserved1[7];
    Bit64 reserved2[15];
};

NN_STATIC_ASSERT(sizeof(AppletAttribute) == 128);

}}

namespace nn { namespace am { namespace service {

enum FocusState
{
    FocusState_Initial = 0,
    FocusState_InFocus = 1,
    FocusState_OutOfFocus = 2,
    FocusState_Background = 3,
};

enum class WindowFocusState
{
    InFocus,
    OutOfFocus,
    Background,
    BackgroundOutOfFocus,
};

enum class Wakefulness
{
    Awake,
    Waking,
    Sleep,
};

enum class FocusStateSet
{
    InFocusOnly,
    InFocusAndOutOfFocus,
    All,
};

enum class ShimLibraryMode
{
    Oe,
    Ae,
};

enum class CoreUsageRequest
{
    None,
    Shared,
    Exclusive,
};

enum class CoreAvailability
{
    None,
    Partial,
    All,
};

enum class GamePlayRecordingState
{
    Stopped,
    Recording,
};

struct AppletProcessLaunchReason
{
    bool unwinding;
    bool reserved[3];
};

struct AppletKind
{
    Bit32 reserved[2];
};

class IntegratedApplet;

typedef std::shared_ptr<IntegratedApplet> IntegratedAppletPointer;

enum EmulatedButtonEvent : uint32_t
{
    EmulatedButtonEvent_PressHomeButtonShort = 1,
    EmulatedButtonEvent_PressHomeButtonLong = 2,
    EmulatedButtonEvent_PressPowerButtonShort = 3,
    EmulatedButtonEvent_PressPowerButtonMiddle = 4,
    EmulatedButtonEvent_PressPowerButtonLong = 5,
};

struct LibraryAppletInfo
{
    Bit32 appletId;
    Bit32 mode;
};

struct ProxyOption
{
    bool forOe{false};
};

enum WirelessPriorityMode : int8_t
{
    WirelessPriorityMode_OptimizedForBluetooth = 1,
    WirelessPriorityMode_OptimizedForWlan = 2,
};

enum ProgramSpecifyKind : uint32_t
{
    SubProgramIndex = 0,
    ApplicationId = 1,
    Same = 2,
};

}}}

namespace nn { namespace sf {

template <>
struct EnablesOut<am::service::IntegratedAppletPointer> : public std::integral_constant<bool, true>
{
};

}}
