﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   HDCP に関する API の宣言
 *
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Common.h>
#include <nn/os.h>

namespace nn { namespace ae {

//-----------------------------------------------------------------------------

//! @name HDCP 制御に関する API
//! @{

/**
 * @brief   HDCP 認証が失敗したときのシステムイベントを取得します。
 *
 * @param[out]   pEvent   取得したシステムイベントの格納先
 *
 * @details
 *  HDCP 認証が失敗したときにシグナルされるシステムイベントを取得します。
 *  こちらのシステムイベントのクリアモードは nn::os::EventClearMode_AutolClear に設定されています。
 *
 *  HDCP 認証は VOD アプリケーションが Foreground に遷移するときに再開されるため、
 *  このシステムイベントはそれまでに確実にクリアするようにして下さい。
 *  通常は割り込みシーンを表示した直後ぐらいにクリアすることを推奨します。
 */
void GetHdcpAuthenticationFailedEvent(os::SystemEvent* pEvent) NN_NOEXCEPT;

//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::ae
