﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   各種アプレットの制御や管理を行なう機能に関するヘッダファイル
 */

#pragma once

/**
 * @namespace   nn::ae
 *
 * @brief   各種アプレットの制御や管理を行なう機能の名前空間です。
 *
 * @details
 *  ### 機能概要
 *  ae とは、Applet Environment の略です。
 *
 *  ae ライブラリでは、システムアプレットやライブラリアプレット、
 *  その他一部のシステムプロセスなどが自身のプログラムの状態遷移を管理したり、
 *  アプリケーションや他のアプレットの起動や終了、情報取得などを行なうための
 *  機能を提供します。
 *
 *  なお、アプリケーションが利用するアプレット関連機能は
 *  nn::oe 名前空間にあり、nn::ae 名前空間にある機能は提供されません。
 *
 *  また、アプレットではない一部のシステムプロセスも、nn::ae の機能を
 *  利用することができます。特にアプレットが受け取る各種通知メッセージを、
 *  システムプロセスが受信するために利用することがあります。
 *
 */

#include <nn/ae/ae_Types.h>
#include <nn/ae/ae_CommonApi.h>
#include <nn/ae/ae_ApplicationControlApi.h>
#include <nn/ae/ae_ApplicationLaunchPropertyApi.h>
#include <nn/ae/ae_BootModeApi.h>
#include <nn/ae/ae_DisplayResolutionApi.h>
#include <nn/ae/ae_HdcpApi.h>
#include <nn/ae/ae_OperationModeApi.h>
#include <nn/ae/ae_SystemAppletApi.h>
#include <nn/ae/ae_LibraryAppletApi.h>
#include <nn/ae/ae_OverlayAppletApi.h>
#include <nn/ae/ae_SystemApplicationApi.h>
#include <nn/ae/ae_AudioControlApi.h>
#include <nn/ae/ae_SleepApi.h>
#include <nn/ae/ae_DebugApi.h>
#include <nn/ae/ae_IdlePolicyApi.h>
#include <nn/ae/ae_Result.h>
#include <nn/ae/ae_ContentAction.h>
