﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/detail/account_ApplicationResourceManager.h>
#include <nn/account/detail/account_Notifiable.h>
#include <nn/account/user/account_UserReference.h>

namespace nn { namespace account { namespace user {

class ApplicationUserStateManager
{
private:
    std::array<UserRef, UserCountMax> m_OpenUsers;

    bool m_IsQualificationLimitationEnabled {false};
    Uid m_QualifiedUsers[UserCountMax];
    int m_QualifiedUserCount;

public:
    ~ApplicationUserStateManager() NN_NOEXCEPT;
    void EnableQualificationLimitation(const Uid users[], int count) NN_NOEXCEPT;
    bool IsQualificationLimitationEnabled() const NN_NOEXCEPT;
    int ListQualifiedUsers(Uid buffer[], int capacity) const NN_NOEXCEPT;
    bool IsUserQualified(const Uid& user) const NN_NOEXCEPT;

    void SetUserStateOpened(UserRef&& user) NN_NOEXCEPT;
    void SetUserStateClosed(const Uid& uid) NN_NOEXCEPT;
    bool IsUserOpened(const Uid& uid) const NN_NOEXCEPT;
    int ListOpenUsers(Uid buffer[], int capacity) const NN_NOEXCEPT;
};

enum UserStateManagerTag
{
    UserStateManagerTag_StateChange
};

class UserStateManager
    : public detail::ApplicationResourceManager<ApplicationUserStateManager>
    , detail::Notifiable<UserStateManagerTag, detail::UserStateManagerNotifierCountMax>
{
private:
    Uid m_LastOpened {InvalidUid};

public:
    using Notifiable::ReleaseSystemEvent;

    void EnableQualificationLimitation(ApplicationId appId, const Uid users[], int count) NN_NOEXCEPT;
    int SelectQualifiedUsers(
        Uid buffer[], int capacity,
        ApplicationId appId, const Uid users[], int count) const NN_NOEXCEPT;

    Result SetUserStateOpened(ApplicationId appId, UserRef&& user) NN_NOEXCEPT;
    Result SetUserStateClosed(ApplicationId appId, const Uid& uid) NN_NOEXCEPT;

    bool IsUserOpened(const Uid& uid) const NN_NOEXCEPT;
    int ListOpenUsers(Uid buffer[], int capacity) const NN_NOEXCEPT;
    int ListOpenUsers(Uid buffer[], int capacity, ApplicationId appId) const NN_NOEXCEPT;

    bool TryGetLastOpenedUser(Uid* pOut) const NN_NOEXCEPT;
    void InvalidateLastOpenedUser() NN_NOEXCEPT;

    Result GetUserStateChangeEvent(os::SystemEventType** pOutEvent) NN_NOEXCEPT;
};

}}} // namespace nn::account::user
