﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <curl/curl.h>

#include <nn/nn_Result.h>
#include <nn/account/ndas/account_AuthenticationCache.h>
#include <nn/account/detail/account_Execution.h>
#include <nn/nsd/nsd_Types.h>

namespace nn { namespace account { namespace ndas {

class NdasDriver
{
    NN_DISALLOW_COPY(NdasDriver);

public:
    static const size_t RequiredBufferSize;

private:
    ApplicationAuthenticationCache& m_AppAuthCache;

public:
    explicit NdasDriver(ApplicationAuthenticationCache& appAuthCache) NN_NOEXCEPT;

    // デバイス認証
    Result LoadDeviceAuthenticationCache(size_t* pOutSizeActual, char* buffer, size_t bufferSize, uint64_t clientId) const NN_NOEXCEPT;
    Result EnsureDeviceAuthenticationCache(uint64_t clientId, bool force, detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    // アプリケーション認証
    bool IsApplicationAuthenticationCacheAvailable(const detail::ApplicationInfo& appInfo) const NN_NOEXCEPT
    {
        return m_AppAuthCache.IsAvailable(appInfo);
    }
    Result LoadApplicationAuthenticationCache(size_t* pOutSizeActual, char* buffer, size_t bufferSize, const detail::ApplicationInfo& appInfo) const NN_NOEXCEPT
    {
        return m_AppAuthCache.Load(pOutSizeActual, buffer, bufferSize, appInfo);
    }
    Result GetApplicationMetaCache(ApplicationMeta* pOut, const detail::ApplicationInfo& appInfo) const NN_NOEXCEPT
    {
        return m_AppAuthCache.GetMeta(pOut, appInfo);
    }
    Result EnsureApplicationAuthenticationCache(
        const detail::ApplicationInfo& appInfo, bool force,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;
};

}}} // ~namespace nn::account::ndas
