﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// 永続化オプション付きのキャッシュ

#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/account/account_Result.h>
#include <nn/account/account_ResultForAdministrators.h>
#include <nn/account/account_ResultPrivate.h>
#include <nn/account/detail/account_CacheBase.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/nas/account_NasTypes.h>

#include <utility>

#include <nn/nn_TimeSpan.h>

namespace nn {
namespace account {
namespace nas {

struct NasUserResourceCacheOperator
{
    static bool IsExpired(int64_t) NN_NOEXCEPT;
    static void DeleteCacheData(const std::pair<detail::Uuid, TimeSpan>& data, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;
};

class NasUserResourceCache
    : detail::CacheBaseN<16, NintendoAccountId, std::pair<detail::Uuid, TimeSpan>, NasUserResourceCacheOperator, detail::DefaultCacheResult>
{
private:
    typedef detail::CacheBaseN<16, NintendoAccountId, std::pair<detail::Uuid, TimeSpan>, NasUserResourceCacheOperator, detail::DefaultCacheResult> Base;

    void InvalidateVolatileCacheUnsafe(const NintendoAccountId& tag) NN_NOEXCEPT
    {
        Base::InvalidateUnsafe(tag);
    }

public:
    Result Initialize(const detail::AbstractLocalStorage& storage) NN_NOEXCEPT
    {
        return Base::Initialize(storage);
    }
    const detail::AbstractLocalStorage& GetStorageRef() const NN_NOEXCEPT
    {
        return Base::GetStorageRef();
    }
    bool IsAvailable(const NintendoAccountId& tag) const NN_NOEXCEPT;
    Result Perpetuate(const NintendoAccountId& tag) NN_NOEXCEPT;
    Result Store(const NintendoAccountId& tag, detail::Uuid&& cacheId) NN_NOEXCEPT;
    Result GetTimeStamp(TimeSpan* pOut, const NintendoAccountId& tag) const NN_NOEXCEPT;
    Result Load(NasUserBase* pOut, const NintendoAccountId& tag, void* rawBuffer, size_t bufferSize) const NN_NOEXCEPT;
    void Invalidate(const NintendoAccountId& tag) NN_NOEXCEPT;
    void InvalidateVolatileCache(const NintendoAccountId& tag) NN_NOEXCEPT
    {
        Base::Invalidate(tag);
    }
};

}
}
} // ~namespace nn::account::nas
