﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/detail/account_Execution.h>
#include <nn/account/json/account_ResultForJson.h>
#include <nn/http/json/http_RapidJsonApi.h>

namespace nn { namespace account { namespace json {

struct DefaultJsonErrorMap
{
    using ResultEmpty = ResultJsonEmpty;
    using ResultDocumentError = ResultJsonDocumentError;
    using ResultSyntaxError = ResultJsonSyntaxError;
    using ResultContentError = ResultJsonContentError;
    using ResultParsingTerminated = ResultJsonParsingTerminated;
    using ResultEnvironmentError = ResultJsonEnvironmentError;
};

template <typename AdaptorType, typename InputStreamType>
Result ImportJsonByRapidJson(
    AdaptorType& adaptor,
    InputStreamType& stream,
    const detail::Cancellable* pCancellable = nullptr) NN_NOEXCEPT
{
    return nn::http::json::ImportJsonByRapidJson<DefaultJsonErrorMap, AdaptorType, InputStreamType, detail::Cancellable>(
        adaptor, stream, pCancellable);
}

}}} // ~namespace nn::account::json
