﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>
#include <nn/nn_Common.h>

namespace nn { namespace account { namespace detail {
class ISessionObject;
}}} // ~namespace nn::account::detail

namespace nn { namespace account {

/**
    @brief アカウントライブラリを使用して行った宣言を保持するためのクラスです。

    @details
        アカウントライブラリを使用して行った宣言を保持するためのクラスです。

        Declaration オブジェクトを生成するAPIを呼んだとき、そこで発行される宣言はこのオブジェクトが有効な期間の有効性が保証されます。
*/
class Declaration
{
private:
    detail::ISessionObject* m_Ptr;

    void Swap(Declaration& rhs) NN_NOEXCEPT;
public:
    Declaration() NN_NOEXCEPT
        : m_Ptr(nullptr)
    {
    }
    Declaration(Declaration&& rhs) NN_NOEXCEPT
        : m_Ptr(rhs.m_Ptr)
    {
        rhs.m_Ptr = nullptr;
    }
    explicit Declaration(detail::ISessionObject* ptr) NN_NOEXCEPT
        : m_Ptr(ptr)
    {
    }
    ~Declaration() NN_NOEXCEPT;
    Declaration& operator=(Declaration&& rhs) NN_NOEXCEPT
    {
        Declaration tmp(std::move(rhs));
        this->Swap(tmp);
        return *this;
    }
};

}} // ~namespace nn::account
