﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection;

namespace Nintendo.ServiceFramework
{
    [Serializable]
    internal enum BufferTransferInternalDirection
    {
        In,
        Out,
    }

    [Serializable]
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false)]
    internal class BufferTransferInternalDirectionAttribute : Attribute
    {
        public BufferTransferInternalDirection Direction { get; private set; }

        public BufferTransferInternalDirectionAttribute(BufferTransferInternalDirection direction)
        {
            this.Direction = direction;
        }
    }

    public class SfNnBuffer : SfEntity
    {
        public SfNnBuffer(Type target)
            : base(target)
        {
        }

        public static bool CanAccept(Type t)
        {
            if (t.IsGenericType)
            {
                var at = t.GetGenericArguments()[0];
                var ate = at.GetSfEntity();
                if (!(ate is SfValueType))
                {
                    return false;
                }
                var gt = t.GetGenericTypeDefinition();
                return false
                    || gt == typeof(nn.sf.InArray<>)
                    || gt == typeof(nn.sf.OutArray<>);
            }
            else
            {
                return false
                    || t == typeof(nn.sf.InBuffer)
                    || t == typeof(nn.sf.OutBuffer);
            }
        }

        internal override IEnumerable<SfEntity> GetReferredEntities()
        {
            return GetStronglyReferredEntities();
        }

        internal override IEnumerable<SfEntity> GetStronglyReferredEntities()
        {
            if (InnerType.IsGenericType)
            {
                var at = InnerType.GetGenericArguments()[0];
                yield return at.GetSfEntity();
            }
        }

        internal override IEnumerable<SfEntity> GetElementEntities()
        {
            if (InnerType.IsGenericType)
            {
                var at = InnerType.GetGenericArguments()[0];
                yield return at.GetSfEntity();
            }
            yield return this;
        }
    }
}
