﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection;

namespace Nintendo.ServiceFramework
{
    public class SfInterface : SfEntity
    {
        public Type Target { get; private set; }

        public static bool CanAccept(Type t)
        {
            return t.IsInterface;
        }

        public SfInterface(Type target)
            : base(target)
        {
            if (target != typeof(nn.sf.IServiceObject))
            {
                new Validation.InterfaceValidator().Validate(target);
            }
            this.Target = target;
        }

        internal override IEnumerable<SfEntity> GetReferredEntities()
        {
            var referred = from e in GetReferredEntitiesInSignature()
                           from e2 in e.GetElementEntities()
                           select e2;
            if (Target.GetInterfaces().Count() > 0)
            {
                var se = Target.GetInheritedOutmostInterface().GetSfEntity();
                return referred.Concat(new[] { se });
            }
            return referred;
        }

        internal override IEnumerable<SfEntity> GetStronglyReferredEntities()
        {
            var referred = from e in GetReferredEntitiesInSignature()
                           from e2 in e.GetElementEntities()
                           where e2 is SfValueType
                           select e2;
            if (Target.GetInterfaces().Count() > 0)
            {
                var se = Target.GetInheritedOutmostInterface().GetSfEntity();
                return referred.Concat(new[] { se });
            }
            return referred;
        }

        private IEnumerable<SfEntity> GetReferredEntitiesInSignature()
        {
            foreach (var m in Target.GetAllInterfaceMethods().SortByMethodId())
            {
                if (m.ReturnType != typeof(void))
                {
                    yield return m.ReturnType;
                }
                foreach (var p in m.GetParameters())
                {
                    yield return p.ParameterType.GetSfParameterElementType();
                }
            }
        }

        internal SfEntity GetBaseInterface()
        {
            return Target.GetInheritedOutmostInterface().GetSfEntity();
        }
    }
}
