﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace Nintendo.RecoveryBoot
{
    public class CommandInterface
    {
        public static bool IsVerbose;
        public static int Main(string[] rawArgs)
        {
            try
            {
                Argument parsed;
                var parser = new Nintendo.Foundation.IO.CommandLineParser();

                if (false == parser.ParseArgs<Argument>(rawArgs, out parsed))
                {
                    return 1;
                }

                IsVerbose = parsed.Verbose;

                Console.Out.Write("Processing.");
                if (IsVerbose)
                {
                    Console.Out.WriteLine();
                }

                int ret = BootQspiMode(parsed);
                if (ret == 0)
                {
                    Console.Out.WriteLine("Complete.");
                }
                else
                {
                    Console.Out.WriteLine("Operation failed.");
                }

                return ret;
            }
            catch (Exception exception)
            {
                PrintException(exception);
                return 1;
            }
        }

        public static void PrintException(Exception exception)
        {
            Console.Out.WriteLine();
            Console.Error.WriteLine("[ERROR] {0}", exception.Message);
            Console.Error.WriteLine("StackTrace: {0}", exception.StackTrace);
        }

        public static int BootQspiMode(Argument args)
        {
            var ret = new BootQspiMode().Execute(args);
            return ret;
        }
    }
}
