﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.InitializeSdev;

using LOG = Nintendo.InitializeSdev.Logger;
using LOG_LEVEL = Nintendo.InitializeSdev.Logger.Level;

namespace Nintendo.InitializeSdev
{
    class HostBridgeFirmwareAccessor
    {
#if EXEC_UPDATEHOSTBRIDGE
        public static ExitStatus UpdateHostBridgeFirmware(string targetKeyString, string version)
        {
            LOG.LogLine("Update HostBridge FW.");

            ExitStatus eStatus = ExitStatus.Failure;

            FirmwareResourceAccessor firmwareResourceAccess = FirmwareResourceAccessor.GetInstance();
            string verString = version == null ? firmwareResourceAccess.GetUpToDateVersion() : version;
            if (verString == null)
            {
                LOG.LogLine(LOG_LEVEL.LOG_ERROR, "HostBridge firmware's directory is not found.");
                return ExitStatus.Failure;
            }
            string hostbridgeFirmwarePath = firmwareResourceAccess.GetFileNameOfFirm(FirmwareType.Firmware_HostBridge, verString, TargetSpecifier.SdevVersion.SDEV_NONE);
            LOG.LogLine(LOG_LEVEL.LOG_INFO2, "hostbridgeFwPath  = {0}", hostbridgeFirmwarePath);

            string targetIp = TargetSpecifier.GetTargetIpFromMac(targetKeyString);
            if (targetIp == null)
            {
                goto quit;
            }

            const string updateHostBridgePath = "UpdateHostBridge.exe";
            int exitCode = -1;

            List<string> argsList = new List<string>();
            List<string> args1 = new List<string>() { "update", "--target", targetIp, "--image", hostbridgeFirmwarePath, "--waitboot", "--verbose" };
            argsList.AddRange(args1);

            ProcessAccessor.DumpProcessArgumentList("UpdateHostBridge", argsList);

            exitCode = ProcessAccessor.DoProcess(updateHostBridgePath, argsList, null);

            if (exitCode != 0)
            {
                exitCode = ProcessAccessor.DoProcess(updateHostBridgePath, argsList, null);
                if (exitCode != 0)
                {
                    goto quit;
                }
            }

            eStatus = ExitStatus.Success;
        quit:
            if (eStatus == ExitStatus.Success)
            {
                LOG.LogLine(LOG_LEVEL.LOG_INFO2, "UpdateHostBridge passed.");
            }
            else
            {
                LOG.LogLine(LOG_LEVEL.LOG_ERROR, "UpdateHostBridge failed.");
            }
            return eStatus;
        }
#else
        public static ExitStatus UpdateHostBridgeFirmware(ref HostBridgeController handle, string targetKeyString, string version)
        {
            FirmwareResourceAccessor firmwareResourceAccess = FirmwareResourceAccessor.GetInstance();
            string verString = version == null ? firmwareResourceAccess.GetUpToDateVersion() : version;
            if (verString == null)
            {
                return ExitStatus.Failure;
            }
            string hostbridgeFirmwarePath = firmwareResourceAccess.GetFileNameOfFirm(FirmwareType.Firmware_HostBridge, verString);

            string targetIp = SdevInitializer.GetTargetIpFromMac(ref handle, targetKeyString);
            if (targetIp == null)
            {
                return ExitStatus.Failure;
            }

            // Call UpdateHostBridge
            List<string> argsList = new List<string>();
            List<string> args1 = new List<string>() { "update", "--target", targetIp, "--image", hostbridgeFirmwarePath, "--waitboot", "--verbose" };
            argsList.AddRange(args1);

#if false
            ProcessAccessor.DumpProcessArgumentList("UpdateHostBridge", argsList);
#endif
            int retVar = Nintendo.UpdateHostBridge.CommandInterface.Main(argsList.ToArray());

            return retVar == 0 ? ExitStatus.Success : ExitStatus.Failure;
        }
#endif
    }
}
