﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Nintendo.InitializeEdev
{
    public partial class InitialDialog : Form
    {
        private int ProgressLabelCount = 0;
        public InitialDialog()
        {
            InitializeComponent();
        }

        private void ProgressTimer_Tick(object sender, EventArgs e)
        {
            string labelString = string.Empty;
            if (++ProgressLabelCount >= 10) ProgressLabelCount = 0;
            for (int i = 0; i < ProgressLabelCount; i++)
            {
                labelString += ".";
            }
            ProgressLabel.Text = labelString;
        }
    }

    public class InitialProgressDialog : IDisposable
    {
        private volatile bool _canceled = false;
        private volatile InitialDialog form;
        private System.Threading.ManualResetEvent startEvent;
        private bool showed = false;
        private volatile bool closing = false;
        private Form ownerForm;

        private System.Threading.Thread thread;

        public bool Canceled
        {
            get { return _canceled; }
        }

        public void Show(Form owner)
        {
            if (showed)
                throw new Exception("InitialProgressDialog is already shown.");
            showed = true;

            _canceled = false;
            startEvent = new System.Threading.ManualResetEvent(false);
            ownerForm = owner;

            thread = new System.Threading.Thread(new System.Threading.ThreadStart(Run));
            thread.IsBackground = true;
            thread.SetApartmentState(System.Threading.ApartmentState.STA);
            thread.Start();

            startEvent.WaitOne();
        }
        public void Show()
        {
            Show(null);
        }

        private void Run()
        {
            form = new InitialDialog();
            form.InitializeCancelButton.Click += new EventHandler(CancelButton_Click);
            form.Closing += new CancelEventHandler(form_Closing);
            form.Activated += new EventHandler(form_Activated);
            if (ownerForm != null)
            {
                form.StartPosition = FormStartPosition.Manual;
                form.Left = ownerForm.Left + (ownerForm.Width - form.Width) / 2;
                form.Top = ownerForm.Top + (ownerForm.Height - form.Height) / 2;
            }
            form.ShowDialog();

            form.Dispose();
        }

        public void Close()
        {
            closing = true;
            form.Invoke(new MethodInvoker(form.Close));
        }

        public void Dispose()
        {
            form.Invoke(new MethodInvoker(form.Dispose));
        }

        private void CancelButton_Click(object sender, EventArgs e)
        {
            _canceled = true;

            // MEMO: close application when cancel
            Application.Exit();
        }

        private void form_Closing(object sender, CancelEventArgs e)
        {
            if (!closing)
            {
                e.Cancel = true;
                _canceled = true;

                // MEMO: close application when cancel
                Application.Exit();
            }
        }

        private void form_Activated(object sender, EventArgs e)
        {
            form.Activated -= new EventHandler(form_Activated);
            startEvent.Set();
        }
    }
}
