﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Text.RegularExpressions;
using Nintendo.Foundation.IO;
//using Nintendo.ControlTarget;

namespace Nintendo.InitializeEdev
{
    public class EdevInitializeCommandArgument
    {
        [CommandLineOption("target",
            Description = "Specifies serial number of target EDEV.")]
        public string target { get; set; }

        [CommandLineOption("target-name", IsHidden = true,
            Description = "[for debug] Specifies name of target EDEV.")]
        public string targetName { get; set; }

        [CommandLineOption("target-serial", IsHidden = true,
            Description = "[for debug] Specifies name of target EDEV.")]
        public string targetSerial { get; set; }

        [CommandLineOption("target-connected-usb", IsHidden = true,
            Description = "[for debug] Use connected EDEV. (TENTATIVE)")]
        public bool targetConnectedUsb { get; set; }

        [CommandLineOption("target-old-usb", IsHidden = true,
            Description = "[for InitializeEdevWinOnly] Use connected EDEV of old safemode.")]
        public bool targetOldConnectedUsb { get; set; }

        [CommandLineOption("target-version",
            Description = "Specifies firmware variation.")]
        public string targetFirmwareVersion { get; set; }

        [CommandLineOption("display-available-version",
            Description = "Display available firmware variation.")]
        public bool displayAvailableVersion { get; set; }

        [CommandLineOption("list-available-targets", IsHidden = true,
            Description = "List available targets.")]
        public bool listAvailableTargets { get; set; }

        [CommandLineOption("xxxx-bsf", IsHidden = true,
            Description = "Execute to boot safemode.")]
        public bool bootSaveMode { get; set; }

        [CommandLineOption("verbose",
            Description = "Log verbosely.")]
        public bool Verbose { get; set; }

        [CommandLineOption("ndi-mode", IsHidden = true,
            Description = "[for ndi] Change output mode for ndi.")]
        public string ndiPipeName { get; set; }

        [CommandLineOption("ndi-locale", IsHidden = true,
            Description = "[for ndi] Specify output locale.")]
        public string ndiLocale { get; set; }

        public enum TargetArgumentType
        {
            TypeName,
            TypeSerial,
            TypeOther
        }

        public bool ParseTarget(ref string targetString, ref TargetArgumentType targetType)
        {
            if (this.targetName != null)
            {
                targetString = this.targetName;
                targetType = TargetArgumentType.TypeName;
                return true;
            }
            else if (this.targetSerial != null)
            {
                targetString = this.targetSerial;
                targetType = TargetArgumentType.TypeSerial;
                return true;
            }
            else if (this.target != null)
            {
                if (Nintendo.InitializeSdev.SerialNumber.CheckSerialString(this.target))
                {
                    targetString = this.target;
                    targetType = TargetArgumentType.TypeSerial;
                }
                else
                {
                    targetString = this.target;
                    targetType = TargetArgumentType.TypeName;
                }
                return true;
            }
            return false;
        }
    }
}
