﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using HidSharp;

namespace Nintendo.DebugBoardPlugin
{
    public static class DebugBoardUtility
    {
        public static void SendSignals(Action<DebugBoardDevice> e)
        {
            var devices = DebugBoardDevice.GetConnectedDevices();
            foreach (var device in devices)
            {
                SendSignals(device, e);
            }
        }
        public static void SendSignals(DebugBoardDevice device, Action<DebugBoardDevice> e)
        {
            e.Invoke(device);
        }
    }
}
