﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class PhidgetsSafeModeCommand : CommandCommon
    {
        [CommandLineOption("phidgets-serial",
        Description = "Set Phidget SerialNumber.",
        DefaultValue = 0)]
        public int SerialNumber { get; set; }

        public override void Run()
        {
            if (SerialNumber == 0)
            {
                PhidgetUtility.SendSignals(e =>
                {
                    PhidgetUtility.EnsureOutput(e, 0, false);   // VolUpを離す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 1, false);   // VolDown を離す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Powerを離す
                    Task.Delay(300).Wait();

                    PhidgetUtility.EnsureOutput(e, 1, true);    // VolDown を押す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, true);    // Power を押す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 1, false);   // VolDown を離す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, true);    // VolUpを押す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Powerを離す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, false);   // VolUpを離す
                });
            }
            else
            {
                PhidgetUtility.SendSignals(e =>
                {
                    PhidgetUtility.EnsureOutput(e, 0, false);   // VolUpを離す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 1, false);   // VolDown を離す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Powerを離す
                    Task.Delay(300).Wait();

                    PhidgetUtility.EnsureOutput(e, 1, true);    // VolDown を押す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, true);    // Power を押す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 1, false);   // VolDown を離す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, true);    // VolUpを押す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Powerを離す
                    Task.Delay(300).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, false);   // VolUpを離す
                },
                SerialNumber, TimeSpan.FromSeconds(1));
            }
        }
    }
}
