﻿using System;
using Nintendo.Foundation.IO;
using Nintendo.Bridge;

namespace Nintendo.ControlTarget
{
    public class ForceRecoveryHostBridgeCommand : CommandCommon
    {
        [CommandLineOption("target-ip", IsRequired = true,
            Description = "Specify the target by IP.")]
        public string TargetIp { get; set; }

        public override void Run()
        {
            try
            {
                using (var control = new BridgeControl(TargetIp))
                {
                    control.ForceRecovery();
                }
            }
            catch (Exception)
            {
                throw new Exception("Failed to boot force recovery mode.");
            }
        }
    }
}
