﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.DebugBoardPlugin;
using Nintendo.Foundation.IO;
namespace Nintendo.ControlTarget
{
    public class DebugBoardSetUsbConnectionCommand : CommandCommon
    {
        [CommandLineValue(0, ValueName = "Connection", Description = "Specifies connection status (connect|disconnect).")]
        public string Connection { get; set; }
        public override void Run()
        {
            DebugBoardUtility.SendSignals(e =>
            {
                switch (Connection)
                {
                    case "connect":
                        e.ConnectUsb(true);
                        break;
                    case "disconnect":
                        e.ConnectUsb(false);
                        break;
                    default:
                        throw new Exception("Please specify \"connect\" or \"disconnect\".");
                }
            });
        }
    }
}
