﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;
using Nintendo.Bridge;

namespace Nintendo.ControlTarget
{
    // PressPowerButtonCommand はターゲットを SC7 まで寝かせたときに使えないので、そのときに使うためのコマンド
    // TargetManager への接続を不要にしている
    public class PressPowerButtonForSc7Command : CommandCommon
    {
        [CommandLineOption("ip-addr",
            Description = "IP address of SDEV.",
            IsRequired = true)]
        public string IpAddr { get; set; }

        [CommandLineOption("hold-time",
            Description = "Hold time (seconds).",
            DefaultValue = 1)]
        public int HoldTime { get; set; }

        public override void Run()
        {
            Telnet hbTelnet = new Telnet();
            if (!hbTelnet.Connect(IpAddr))
            {
                throw new Exception("HostBridge connection failed.");
            }
            hbTelnet.Login();
            string command = String.Format("ngpio_test -d 1 -p 1; ngpio_test -p 1 -w 1; sleep {0}; ngpio_test -p 1 -w 0", HoldTime);
            hbTelnet.WaitCommand(command);
            System.Threading.Thread.Sleep((HoldTime + 1) * 1000);
        }
    }
}
