﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class ListDetectedTargetCommand : CommandCommon
    {
        [CommandLineOption("timeout",
            Description = "Set timeout of detecting targets as seconds.",
            DefaultValue = 5)]
        public int Timeout { get; set; }

        [CommandLineOption("xml",
            Description = "Output target infomations by XML.",
            DefaultValue = false)]
        public bool Xml { get; set; }

        [CommandLineOption("csv",
            Description = "Output target infomations by CSV.",
            DefaultValue = false)]
        public bool Csv { get; set; }

        public override void Run()
        {
            RunCommand(
                () =>
                {
                    var timeout = TimeSpan.FromSeconds(Timeout);

                    if (Xml)
                    {
                        Console.WriteLine(ListTargetCommand.DetectTargetAsXml(timeout));
                    }
                    else if (Csv)
                    {
                        Console.Write(ListTargetCommand.DetectTargetAsCsv(timeout));
                    }
                    else
                    {
                        Console.WriteLine(ListTargetCommand.Run(true, timeout, false));
                    }
                });
        }
    }
}
