﻿using System.IO;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class InstallApplicationCommand : CommonDevMenuCommandCommand
    {
        [CommandLineValue(0, ValueName = "nsp path", Description = "Specifies nsp path for installing.")]
        public string ApplicationNspPath { get; set; }

        public override void Run()
        {
            RunDevMenuCommandCommand(() => {
                RunDevMenuCommand(
                    "application",
                    "install",
                    Path.GetFullPath(ApplicationNspPath));
            });
        }
    }
}
