﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;
using Nintendo.Bridge;

namespace Nintendo.ControlTarget
{
    public class FindTargetCommand : CommandCommon
    {
        [CommandLineOption("timeout",
            Description = "Set timeout of detecting targets as seconds.",
            DefaultValue = 5)]
        public int Timeout { get; set; }

        public override void Run()
        {
            RunCommand(
                () =>
                {
                    var timeout = TimeSpan.FromSeconds(Timeout);

                    Console.WriteLine(FindTargetCommand.Run(true, timeout, false));
                });
        }

        public static string Run(bool detect, TimeSpan timeout, bool allInfo)
        {
            StringBuilder targetIp = new StringBuilder();
            StringBuilder targetPort = new StringBuilder();

            var ret = new StringBuilder();

            int targetNum;
            string[] targetIPs;
            int[] targetPorts;
            string[] targetNames;
            string[] targetMacs;
            uint[] targetVersions;
            string[] targetSerialNumbers;

            Console.WriteLine("Finding target...");
            BridgeDetect detector = new BridgeDetect();
            detector.Enumerate(out targetNum, out targetIPs, out targetPorts, out targetNames, out targetMacs, out targetVersions, out targetSerialNumbers, (int)timeout.TotalMilliseconds, true);

            for (int i = 0; i < targetNum; i++)
            {
                if (allInfo)
                {
                    ret.AppendLine(string.Format("{0}\t{1}\t{2}\t{3}\t{4}\t{5}\t{6}\t{7}",
                        string.IsNullOrEmpty(targetNames[i]) ? "<NoName>" : targetNames[i],
                        string.IsNullOrEmpty(targetIPs[i]) ? "<NoIpAddress>" : targetIPs[i],
                        targetVersions[i],
                        string.IsNullOrEmpty(targetMacs[i]) ? "<NoMacAddress>" : targetMacs[i],
                        "<NoSpec>",
                        "<NoConnectionType>",
                        "<NoHardwareType>",
                        string.IsNullOrEmpty(targetSerialNumbers[i]) ? "<NoSerialNumber>" : targetSerialNumbers[i]
                        ));
                }
                else
                {
                    ret.AppendLine(string.Format("{0}\t{1}",
                        string.IsNullOrEmpty(targetNames[i]) ? "<NoName>" : targetNames[i],
                        string.IsNullOrEmpty(targetIPs[i]) ? "<NoIpAddress>" : targetIPs[i]));
                }
            }

            return ret.ToString().TrimEnd();
        }
    }
}
