﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class CreateTargetProgramDumpCommand : CommonTargetCommand
    {
        [CommandLineValue(0, ValueName = "File path", Description = "Full path to output.")]
        public string FullPath { get; set; }

        [CommandLineValue(1, ValueName = "Dump type", Description = "Specify \"full\" or \"quick\"")]
        public string DumpType { get; set; }

        public override void Run()
        {
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    Trace.WriteLine($"Creating a nxdmp file. handle={info.GetTargetHandle()}");
                    target.EnsureConnect();
                    Tmapi.DumpType dumpType;
                    switch (DumpType)
                    {
                        case "full":
                            dumpType = Tmapi.DumpType.Full;
                            break;
                        case "quick":
                        default:
                            dumpType = Tmapi.DumpType.Quick;
                            break;
                    }
                    target.CreateTargetProgramDump(FullPath, dumpType);
                });
        }
    }
}
