﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nn.Adl.Semantics;

namespace Nn.ResultTool.Semantics
{
    internal class DirectExpression : Expression
    {
        public string Text { get; set; }
    }

    internal class SyntaxToSemanticsExpressionConverter : DefaultSyntaxToSemanticsExpressionConverter
    {
        internal Expression ConvertImpl(SemanticEnvironment environment, Nn.ResultTool.Syntax.SymboledLiteralExpression expression)
        {
            switch (expression.Symbol.Value)
            {
                case "$": return new DirectExpression { Text = (string)expression.Literal.GetValue() };
                default: throw null;
            }
        }
    }

    internal class SyntaxToSemanticsModificationConverter : DefaultSyntaxToSemanticsModificationConverter
    {
        public SyntaxToSemanticsModificationConverter()
        {
            this.SyntaxToSemanticsExpressionConverter = new SyntaxToSemanticsExpressionConverter();
        }

        internal new Modification ConvertImpl(SemanticEnvironment environment, Nn.Adl.Syntax.NonValueModification modification)
        {
            switch (modification.DefineeName.Name)
            {
                case "public":
                case "private":
                    {
                        return new Modification
                        {
                            Name = "Package",
                            Expression = new ImmediateExpression { Value = modification.DefineeName.Name }
                        };
                    }
                case "abstract":
                    {
                        return new Modification
                        {
                            Name = "Abstract",
                            Expression = new ImmediateExpression { Value = true }
                        };
                    }
            }
            return base.ConvertImpl(environment, modification);
        }
    }
}
