﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class RegisterUsageTracer
    {
        private Dictionary<int, string> m_usage = new Dictionary<int, string>();

        public void Occupy(int regNo, string usage)
        {
            if (m_usage.ContainsKey(regNo))
            {
                throw new ErrorException(
                    string.Format("レジスタ r{0} への上書きが発生しました。", regNo),
                    string.Format("以前の使用： {0}\n今回の使用： {1}", m_usage[regNo], usage));
            }

            m_usage[regNo] = usage;
        }
        public void Release(int regNo)
        {
            m_usage.Remove(regNo);
        }
        public bool TryOccupy(int regNo, string usage)
        {
            if (IsUsing(regNo))
            {
                return false;
            }

            m_usage[regNo] = usage;
            return true;
        }
        public bool IsUsing(int regNo)
        {
            return m_usage.ContainsKey(regNo);
        }
        public RegisterUsageTracer Clone()
        {
            var copy = (RegisterUsageTracer)this.MemberwiseClone();
            copy.m_usage = m_usage.ToDictionary(x => x.Key, x => x.Value);
            return copy;
        }
    }
}
