﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class PathSet
    {
        public string RootPath { get; private set; }
        public string IncludePath { get; private set; }

        public string IdIncludeTemplate { get; private set; }
        public string TypeIncludeTemplate { get; private set; }
        public string StubHeaderIncludeTemplate { get; private set; }

        public string IdPathTemplate { get; private set; }
        public string TypePathTemplate { get; private set; }
        public string StubHeaderPathTemplate { get; private set; }
        public string StubSourePathTemplate { get; private set; }
        public string HandlerTablePath { get; private set; }
        public string HandlerHeaderPath { get; private set; }
        public string DriverHeaderPath { get; private set; }
        public string DriverSourcePath { get; private set; }
        public string ProfilerStubSourePathTemplate { get; private set; }
        public string ProfilerSourcePath { get; private set; }

        public PathSet(CommandLineOption option)
        {
            var include = option.OutInclude ?? "Include";

            RootPath = option.OutRootPath;
            IncludePath = Path.Combine(RootPath, include);

            IdIncludeTemplate = option.OutIdPath ?? "nn/svc/svc_*Id.h";
            TypeIncludeTemplate = option.OutTypePath ?? "nn/svc/svc_*Type.h";
            StubHeaderIncludeTemplate = option.OutStubHeaderPath ?? "nn/svc/svc_*.h";
            var stubSourcePartTemplate = option.OutStubSourcePath ?? "Sources/Libraries/svc/svc_*.S";
            var handlerTablePart = option.OutTablePath ?? "Sources/Kernel/svc/svc_HandlerTable.cpp";
            var handlerHeaderPart = option.OutHandlersPath ?? "Sources/Kernel/svc/svc_Handlers.h";
            var driverHeaderPart = option.OutDriverHeaderPath ?? "Sources/Kernel/svc/svc_Drivers.h";
            var driverSourcePart = option.OutDriverSourcePath ?? "Sources/Kernel/svc/svc_Drivers.S";
            var profilerStubSourcePartTemplate = option.OutProfilerStubSourcePath ?? "Sources/Libraries/svc/svc_profiler_*.S";
            var profilerSourcePart = option.OutProfilerSourcePath ?? "Sources/Libraries/svc/svc_profiler.cpp";

            IdPathTemplate = Path.Combine(IncludePath, IdIncludeTemplate);
            TypePathTemplate = Path.Combine(IncludePath, TypeIncludeTemplate);
            StubHeaderPathTemplate = Path.Combine(IncludePath, StubHeaderIncludeTemplate);

            StubSourePathTemplate = Path.Combine(RootPath, stubSourcePartTemplate);
            HandlerTablePath = Path.Combine(RootPath, handlerTablePart);
            HandlerHeaderPath = Path.Combine(RootPath, handlerHeaderPart);
            DriverHeaderPath = Path.Combine(RootPath, driverHeaderPart);
            DriverSourcePath = Path.Combine(RootPath, driverSourcePart);
            ProfilerStubSourePathTemplate = Path.Combine(RootPath, profilerStubSourcePartTemplate);
            ProfilerSourcePath = Path.Combine(RootPath, profilerSourcePart);
        }
    }
}
