﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Foundation.IO;

namespace MakeNso
{
    /// <summary>
    /// コマンドラインオプションを設定するクラスです。
    /// </summary>
    internal class MakeNsoParams
    {
        [CommandLineOption("module-name",
            Description = "Set module name for the NSO file.",
            DefaultValue = "")
        ]
        public string ModuleName { get; set; }

        [CommandLineOption("verbose",
            DefaultValue = false,
            Description = "Show log")
        ]
        public bool VerboseMode { get; set; }

        [CommandLineOption("compress",
            DefaultValue = false,
            Description = "Compress the contents")
        ]
        public bool Compress { get; set; }

        [CommandLineOption("nocompress",
            DefaultValue = false,
            Description = "Not compress the contents")
        ]
        public bool NoCompress { get; set; }

        [CommandLineOption("extract",
            DefaultValue = false,
            Description = "Extract the contents")
        ]
        public bool Extract { get; set; }

        [CommandLineValue(0, ValueName = "INPUT_FILE", Description = "Input filename.")]
        public string InputFileName { get; set; }

        [CommandLineValue(1, ValueName = "OUTPUT_FILE", Description = "Output filename.")]
        public string OutputFileName { get; set; }
    }
}
