﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace MakeNso.Elf
{
    /// <summary>
    /// GNU が定義する ELF ファイルのノートセクションを管理するクラス
    /// </summary>
    public static class ElfGnuNoteSection
    {
        private const string Gnu = "GNU\0";

        public static bool IsElfGnuNoteSection(ElfNoteSectionInfo info)
        {
            string name = System.Text.ASCIIEncoding.ASCII.GetString(info.Name);

            if (Gnu != name)
            {
                return false;
            }
            return true;
        }

        public static ElfGnuNoteSectionType GetGnuNoteSectionType(ElfNoteSectionInfo info)
        {
            switch(info.NoteType)
            {
                case 3: return ElfGnuNoteSectionType.BuildId;
                default: return ElfGnuNoteSectionType.Unknown;
            }
        }
    }
}
