﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using Nintendo.Foundation.IO;

namespace MakeNro
{
    /// <summary>
    /// プログラムの引数からパラメータを設定するクラスです。
    /// </summary>
    internal class MakeNroArgs
    {
        private MakeNroParams parameters;
        public MakeNroParams Params
        {
            get { return parameters; }
        }

        /// <summary>
        /// プログラムの引数からパラメータを設定します。
        /// </summary>
        /// <param name="args">プログラムの引数</param>
        /// <returns>パラメータ設定の可否</returns>
        public bool ParseArgs(string[] args)
        {
            var setttings = new CommandLineParserSettings()
            {
                ApplicationDescription = "MakeNro converts DSO file to NRO file.",
                HelpWriter = text =>
                {
                    Console.WriteLine(text);
                },
            };

            if (!new CommandLineParser(setttings).ParseArgs(args, out parameters))
            {
                return false;
            }

            return true;
        }
    }
}
