﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace MakeMeta
{
    internal class MakeMetaParams
    {
        [CommandLineOption("meta",
            IsRequired = true,
            Description = "Option_MetaDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Path")]
        public string InputMetaPath { get; set; }
        [CommandLineOption("desc",
            IsRequired = true,
            Description = "Option_DescDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Path")]
        public string InputDescPath { get; set; }
        [CommandLineOption('o',
            IsRequired = true,
            Description = "Option_OutputDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Path")]
        public string OutputNpdmPath { get; set; }
        [CommandLineOption("kernel_version",
            IsRequired = false,
            Description = "Option_KernelVersionDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Version")]
        public string KernelVersion { get; set; }
        [CommandLineOption("default_core_version",
            IsRequired = false,
            // ToolFoundation の仕様により、ダミーのメッセージを入れておく
            // IsHidden なので、表示はされない
            Description = "Option_KernelVersionDescription",
            DescriptionConverterName = "LocalizeDescription",
            IsHidden = true)]
        public uint DefaultCoreVersion { get; set; }
        [CommandLineOption('d',
            IsRequired = false,
            Description = "Option_MacroDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Macro")]
        public string[] OptionVariables { get; set; }
        [CommandLineOption("no_check_programid",
            IsRequired = false,
            // ToolFoundation の仕様により、ダミーのメッセージを入れておく
            // IsHidden なので、表示はされない
            Description = "Option_KernelVersionDescription",
            DescriptionConverterName = "LocalizeDescription",
            IsHidden = true)]
        public bool NoCheckProgramId { get; set; }

        /// <summary>
        /// ローカライズしたオプションの説明を取得します。
        /// </summary>
        /// <param name="description">Descriptionプロパティの値</param>
        /// <param name="valueName">引数名またはオプション名</param>
        /// <returns>ローカライズされたコマンドラインオプショ
        public static string LocalizeDescription(string description, string valueName)
        {
            string result = Properties.Resources.ResourceManager.GetString(description, Properties.Resources.Culture);
            System.Diagnostics.Debug.Assert(result != null, "コマンドオプションの Description が null");

            return result;
        }
    }
}
