﻿using System;
using System.Xml;
using System.Collections.Generic;


namespace DescModel
{
    [System.Xml.Serialization.XmlRoot("KernelCapabilityData")]
    public class KcDataModel
    {
        [System.Xml.Serialization.XmlElement("ThreadInfo")]
        public KcThreadInfoModel ThreadInfo { get; set; }

        [System.Xml.Serialization.XmlElement("EnableSystemCalls")]
        public List<string> EnableSystemCalls { get; set; }

        [System.Xml.Serialization.XmlElement("MemoryMap")]
        public List<KcMemoryMapModel> MemoryMap { get; set; }

        [System.Xml.Serialization.XmlElement("EnableInterrupts")]
        public List<string> EnableInterrupts  { get; set; }

        [System.Xml.Serialization.XmlElement("MiscParams")]
        public KcMiscParamsModel MiscParams { get; set; }

        [System.Xml.Serialization.XmlIgnore]
        public ushort HandleTableSizeValue { get; set; }
        private string _HandleTableSize;
        [System.Xml.Serialization.XmlElement("HandleTableSize")]
        public string HandleTableSize
        {
            get { return _HandleTableSize; }
            set
            {
                if (value == null)
                {
                    return;
                }
                HandleTableSizeValue = checked ((ushort)ConvertUtils.ConvertDecimalString(value, "KernelCapabilityData/HandleTableSize"));
                if (HandleTableSizeValue >= 1024)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidValue_Bigger, "KernelCapabilityData/HandleTableSize", 1023));
                }
                _HandleTableSize = value;
            }
        }

        [System.Xml.Serialization.XmlElement("MiscFlags")]
        public KcMiscFlags MiscFlags { get; set; }
    }

    [System.Xml.Serialization.XmlRoot("KernelCapabilityData")]
    public class KcDataModelWithSvcInfo
    {
        [System.Xml.Serialization.XmlElement("ThreadInfo")]
        public KcThreadInfoModel ThreadInfo { get; set; }

        [System.Xml.Serialization.XmlElement("EnableSystemCalls")]
        public List<KcEnableSystemCallsModel> EnableSystemCalls { get; set; }

        [System.Xml.Serialization.XmlElement("MemoryMap")]
        public List<KcMemoryMapModel> MemoryMap { get; set; }

        [System.Xml.Serialization.XmlElement("EnableInterrupts")]
        public List<string> EnableInterrupts  { get; set; }

        [System.Xml.Serialization.XmlElement("MiscParams")]
        public KcMiscParamsModel MiscParams { get; set; }

        [System.Xml.Serialization.XmlElement("KernelVersion")]
        public KcKernelVersionModel KernelVersion { get; set; }

        [System.Xml.Serialization.XmlIgnore]
        public ushort HandleTableSizeValue { get; set; }
        private string _HandleTableSize;
        [System.Xml.Serialization.XmlElement("HandleTableSize")]
        public string HandleTableSize
        {
            get { return _HandleTableSize; }
            set
            {
                if (value == null)
                {
                    return;
                }
                HandleTableSizeValue = checked((ushort)ConvertUtils.ConvertDecimalString(value, "KernelCapabilityData/HandleTableSize"));
                if (HandleTableSizeValue >= 1024)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidValue_Bigger, "KernelCapabilityData/HandleTableSize", 1023));
                }
                _HandleTableSize = value;
            }
        }

        [System.Xml.Serialization.XmlElement("MiscFlags")]
        public KcMiscFlags MiscFlags { get; set; }
    }
}
