﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.IO.Compression;

namespace MakeFirmwareArchive
{
    public class FirmwareArchiveDirectory
    {
        public FirmwareArchiveDirectory(DirectoryInfo extractedDirectory)
        {
            this.Directory = extractedDirectory;
        }

        public static FirmwareArchiveDirectory FromFirmwareArchive(DirectoryInfo outputDirectory, FileInfo inputNfa)
        {
            if (inputNfa.Extension != ".nfa")
            {
                throw new Exception(string.Format("Invalid extension(needs .nfa): {0}", inputNfa.FullName));
            }

            if (!new DirectoryInfo(outputDirectory.FullName).Exists)
            {
                throw new Exception(string.Format("Not exist directory: {0}", outputDirectory.FullName));
            }

            ZipFile.ExtractToDirectory(inputNfa.FullName, outputDirectory.FullName);

            return new FirmwareArchiveDirectory(outputDirectory);
        }

        //!< .nfa 形式のファイルに圧縮します
        //TODO: 圧縮形式を nsp に変更（今は zip）
        public void ArchiveNfa(FileInfo outputPath)
        {
            if (outputPath.Extension != ".nfa")
            {
                throw new Exception(string.Format("Invalid extension(needs .nfa): {0}", outputPath.FullName));
            }

            //既存のファイルを削除して上書き
            if (outputPath.Exists)
            {
                outputPath.Delete();
            }

            ZipFile.CreateFromDirectory(this.Directory.FullName, outputPath.FullName);
        }

        public DirectoryInfo Directory { get; private set; }

        public DirectoryInfo SystemDirectory
        {
            get
            {
                return new DirectoryInfo(Path.Combine(this.Directory.FullName, "SYSTEM"));
            }
        }

        public List<FileInfo> GetSystemNspList(DirectoryInfo extractedNfa)
        {
            return SystemDirectory.EnumerateFiles("*.nsp").ToList();
        }

        public DirectoryInfo SafeDirectory
        {
            get
            {
                return new DirectoryInfo(Path.Combine(this.Directory.FullName, "SAFE"));
            }
        }

        public List<FileInfo> GetSafeNspList(DirectoryInfo extractedNfa)
        {
            return SafeDirectory.EnumerateFiles("*.nsp").ToList();
        }

        public DirectoryInfo RecoveryDirectory
        {
            get
            {
                return new DirectoryInfo(Path.Combine(this.Directory.FullName, "Recovery"));
            }
        }

        public List<FileInfo> GetRecoveryFileList(string fileName)
        {
            return RecoveryDirectory.EnumerateFiles("*" + fileName + "*").ToList();
        }

        public DirectoryInfo NormalPackage1Directory
        {
            get
            {
                return new DirectoryInfo(Path.Combine(this.Directory.FullName, "BootPartition1-Normal-Package1-Main"));
            }
        }

        public List<FileInfo> GetNormalPackage1()
        {
            return NormalPackage1Directory.EnumerateFiles("*").ToList();
        }

        public DirectoryInfo NormalPackage2Directory
        {
            get
            {
                return new DirectoryInfo(Path.Combine(this.Directory.FullName, "BCPKG2-1-Normal-Main"));
            }
        }

        public List<FileInfo> GetNormalPackage2()
        {
            return NormalPackage2Directory.EnumerateFiles("*").ToList();
        }

        public DirectoryInfo GetDirectoryInfo(string partitionName)
        {
            if(!FirmwareArchivePartition.IsValidPartitionName(partitionName))
            {
                throw new Exception(string.Format("Invalid partition name: {0}", partitionName));
            }

            return new DirectoryInfo(Path.Combine(this.Directory.FullName, partitionName));
        }
    }
}
