﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using Nintendo.Foundation.IO;

namespace MakeFirmwareArchive
{
    public class Program
    {
        static void Main(string[] args)
        {
#if !DEBUG
            try
            {
#endif
            MakeFirmwareArchiveCommand parsed;
            if(!CommandLineParser.Default.ParseArgs(args, out parsed))
            {
                System.Environment.Exit(1);
            }
            if (parsed.ArchiveNfaCommand != null)
            {
                var inputDirectory = new DirectoryInfo(parsed.ArchiveNfaCommand.InputPath);
                var outputFile = new FileInfo(parsed.ArchiveNfaCommand.OutputPath);
                ArchiveNfaCommand.ArchiveNfa(outputFile, inputDirectory);
            }
            else if (parsed.CreateNfaCommand != null)
            {
                var variables = parsed.CreateNfaCommand.MakeVariablesDictionary();
                var inputFile = parsed.CreateNfaCommand.InputPath;
                var outputFile = parsed.CreateNfaCommand.OutputPath;

                CreateNfaCommand.MakeFirmwareArchive(inputFile, outputFile, variables);
            }
            else if (parsed.ExtractNfaCommand != null)
            {
                var inputFile = new FileInfo(parsed.ExtractNfaCommand.InputPath);
                var outputDirectory = new DirectoryInfo(parsed.ExtractNfaCommand.OutputPath);
                ExtractNfaCommand.extractNfa(outputDirectory, inputFile);
            }
            else if(parsed.CalculateHashCommand != null)
            {
                var inputFile = new FileInfo(parsed.CalculateHashCommand.InputPath);
                var outputFile = new FileInfo(parsed.CalculateHashCommand.OutputPath);
                var filter = parsed.CalculateHashCommand.Filter;
                CalculateHashCommand.CalculateHash(outputFile, inputFile, filter);
            }
            else if (parsed.ExecuteListCommand != null)
            {
                var inputFile = new FileInfo(parsed.ExecuteListCommand.InputPath);
                var outputFile = new FileInfo(parsed.ExecuteListCommand.OutputPath);
                var listFile = new FileInfo(parsed.ExecuteListCommand.ListPath);
                ExecuteListCommand.ExecuteList(outputFile, inputFile, listFile);
            }
            else if(parsed.PartitionListCommand != null)
            {
                PartitionListCommand.PrintPartition();
            }
            else
            {
                return;
            }
#if !DEBUG
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("エラー: {0}", exception.Message);
                Console.Error.WriteLine("{0}", exception.StackTrace);
                Environment.Exit(1);
            }
#endif
        }
    }
}
