﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------using System;
using System;
using System.Security.Cryptography;
using System.Xml;

namespace MakeDesc
{
    public class KeyManager
    {
        public const int RsaKeySize = 2048;

        public RSAParameters PrivateKey { get; private set; }

        public RSAParameters HeaderKey { get; private set; }

        public KeyManager()
        {
            this.keyFile = null;
            keyXml = null;
        }

        public void LoadPrivateKeyFile(string filename)
        {
            this.keyFile = new PemRsaPrivateKeyFile(filename);
            this.PrivateKey = this.keyFile.RsaPrivateKey;
            RSACryptoServiceProvider csp = new RSACryptoServiceProvider(RsaKeySize);
            this.HeaderKey = csp.ExportParameters(true);
            this.keyXml = csp.ToXmlString(true);
        }

        public XmlElement ExportHeaderKeyXml(XmlDocument xml)
        {
            if (!this.HasKey())
            {
                return null;
            }

            XmlDocument keyDoc = new XmlDocument();
            keyDoc.LoadXml(this.keyXml);
            XmlElement keyElem = keyDoc.DocumentElement;
            XmlElement elem = xml.CreateElement(keyElem.Name);

            foreach (XmlNode node in keyElem.ChildNodes)
            {
                XmlNode copyNode = xml.ImportNode(node, true);
                elem.AppendChild(copyNode);
            }

            return elem;
        }

        public bool HasKey()
        {
            return (keyFile != null);
        }

        private PemRsaPrivateKeyFile keyFile;
        private string keyXml;
    }
}
