﻿using System;
using System.Xml;

namespace DescModel
{
    [System.Xml.Serialization.XmlRoot("Desc", IsNullable=false)]
    public class InputDescModel
    {
        public InputDescModel()
        {
            _ProgramIdMax = "0xFFFFFFFFFFFFFFFF";
            _ProgramIdMin = "0x0";
            ProgramIdMaxValue = 0xFFFFFFFFFFFFFFFF;
            ProgramIdMinValue = 0x0;
            NeedDescSignatureValue = false;
            ProductionFlagValue = false;
            UnqualifiedApprovalValue = false;
            MemoryRegion = 0xFF;
            DescVersion = 0;
        }

        [System.Xml.Serialization.XmlIgnore]
        public UInt64 ProgramIdMinValue { get; set; }
        private string _ProgramIdMin;

        [System.Xml.Serialization.XmlElement("ProgramIdMin")]
        public string ProgramIdMin
        {
            get { return _ProgramIdMin; }
            set
            {
                if (value == null)
                {
                    return;
                }
                ProgramIdMinValue = ConvertUtils.ConvertHexString(value, "Desc/ProgramIdMin");
                _ProgramIdMin = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public UInt64 ProgramIdMaxValue { get; set; }
        private string _ProgramIdMax;
        [System.Xml.Serialization.XmlElement("ProgramIdMax")]
        public string ProgramIdMax
        {
            get { return _ProgramIdMax; }
            set
            {
                if (value == null)
                {
                    return;
                }
                ProgramIdMaxValue = ConvertUtils.ConvertHexString(value, "Desc/ProgramIdMax");
                _ProgramIdMax = value;
            }
        }

        [System.Xml.Serialization.XmlElement("FsAccessControlDescriptor")]
        public FaDescriptorModel FsAccessControlDescriptor { get; set; }

        [System.Xml.Serialization.XmlElement("SrvAccessControlDescriptor")]
        public SaDescriptorModel SrvAccessControlDescriptor { get; set; }

        [System.Xml.Serialization.XmlElement("KernelCapabilityDescriptor")]
        public KcDescriptorModel KernelCapabilityDescriptor { get; set; }

        [System.Xml.Serialization.XmlElement("Default", IsNullable=false)]
        public DefaultModel Default { get; set; }

        // メモ:
        // NeedDescSignatureValue を中継する意味はそんなにないが、
        // XML から bool で直接受け取ろうとすると true/false しか受け付けてくれず True/False がエラーになる。
        // 現状は互換性維持のため True/False を受け付けている。いずれ整理したい。

        [System.Xml.Serialization.XmlIgnore]
        public bool NeedDescSignatureValue;
        [System.Xml.Serialization.XmlElement("NeedSignature", IsNullable = false)]
        public string NeedDescSignature
        {
            get { return Convert.ToBoolean(NeedDescSignatureValue).ToString(); }
            set { NeedDescSignatureValue = ConvertUtils.ConvertBoolString(value, "NeedSignature"); ; }
        }

        [System.Xml.Serialization.XmlIgnore]
        public bool UnqualifiedApprovalValue;
        [System.Xml.Serialization.XmlElement("UnqualifiedApproval", IsNullable = false)]
        public string UnqualifiedApproval
        {
            get { return Convert.ToBoolean(UnqualifiedApprovalValue).ToString(); }
            set { UnqualifiedApprovalValue = ConvertUtils.ConvertBoolString(value, "UnqualifiedApproval"); ; }
        }

        [System.Xml.Serialization.XmlIgnore]
        public bool ProductionFlagValue;
        [System.Xml.Serialization.XmlElement("Production", IsNullable = false)]
        public string ProductionFlag
        {
            get { return Convert.ToBoolean(ProductionFlagValue).ToString(); }
            set { ProductionFlagValue = ConvertUtils.ConvertBoolString(value, "Production"); ; }
        }

        [System.Xml.Serialization.XmlElement("MemoryRegion", IsNullable = false)]
        public byte MemoryRegion { get; set; }

        [System.Xml.Serialization.XmlElement("DescVersion", IsNullable = false)]
        public byte DescVersion { get; set; }
    }
}
