﻿using System.Collections.Generic;

namespace Nintendo.Log
{
    public class LogFilter
    {
        private static LogFilterParser Parser = new LogFilterParser();

        public static bool Evaluate(string text, Dictionary<string, object> log)
        {
            if (string.IsNullOrEmpty(text))
            {
                return true;
            }

            var result = Parser.Evaluate(text).Evaluate(log);
            if (!(result is bool))
            {
                return false;
            }
            return (bool)result;
        }

        public static void CheckSyntax(string text)
        {
            if (string.IsNullOrEmpty(text))
            {
                return;
            }
            try
            {
                Parser.Evaluate(text);
            }
            catch
            {
                throw;
            }
        }
    }
}
