﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using HtcDaemon.Builtin;

namespace HtcDaemon
{
    internal static class ProgramOptions
    {
        private static bool directSocketEnabled = true;
        private static bool serialSocketEnabled = true;
        private static bool usbEnabled = true;

        public static bool DirectSocketEnabled { get { return directSocketEnabled; } }
        public static bool SerialSocketEnabled { get { return serialSocketEnabled; } }
        public static bool UsbEnabled { get { return usbEnabled; } }

        // 引数を解釈する。とりあえずの実装。
        public static void ParseArgs(string[] args)
        {
            foreach (string arg in args)
            {
                switch (arg)
                {
                    case "--no-directsocket":
                        directSocketEnabled = false;
                        break;

                    case "--no-serialsocket":
                        serialSocketEnabled = false;
                        break;

                    case "--no-usb":
                        usbEnabled = false;
                        break;
                }
            }
        }
    }

    internal class Program
    {
        private static List<BuiltInServiceBase> builtinApps = new List<BuiltInServiceBase>();

        private static void LaunchBuiltinApp<T>()
            where T : BuiltInServiceBase, new()
        {
            var app = new T();
            app.Start();
            builtinApps.Add(app);
        }

        private static void StopBuiltinApps()
        {
            foreach (var app in builtinApps)
            {
                app.Stop();
            }
        }

        private static void Main(string[] args)
        {
            ProgramOptions.ParseArgs(args);
            ProgramConfiguration.Load();

            using (var daemon = new HostDaemon())
            {
                daemon.Start();

                // ビルトインアプリを起動
                LaunchBuiltinApp<HtcDaemon.Builtin.HostFs.HostFsApp>();

                daemon.DebugConsole();

                StopBuiltinApps();
            }
        }
    }
}
